#pragma once

#include <util/generic/string.h>

class TPathName
{
private:
    TString Pathname;
    TString Basename;

public:
    explicit TPathName(const TString& pathname);

    TPathName(const TPathName& other) = default;
    TPathName& operator=(const TPathName& other) = default;

    bool operator==(const TPathName& other) const { return Pathname == other.Pathname; }

    const TString& PathName() const { return Pathname; }
    const TString& BaseName() const { return Basename; }
};

