#include "port.h"

#include <util/network/socket.h>

bool IsPortFree(ui16 port) {
    TSocket Socket(::socket(AF_INET, SOCK_STREAM, 0));
    sockaddr_in addr;
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = htonl(INADDR_ANY);
    addr.sin_port = htons(port);
    int yes = 1;
    ::setsockopt(Socket, SOL_SOCKET, SO_REUSEADDR, (const char*)&yes, sizeof(yes));
    return ::bind(Socket, (const sockaddr*)&addr, sizeof(sockaddr_in)) != SOCKET_ERROR;
}
