#include "stream_messages.h"

#include <saas/rtyserver/model/index.h>

TMessageGetIndexTimestamp::TMessageGetIndexTimestamp()
    : TMessageGetIndexTimestamp(IIndexController::FINAL_MASK)
{}

void TMessageGetIndexTimestamp::Merge(const IIndexController& index) {
    if (index.GetType() & IndexTypeMask) {
        Timestamp.Merge(index.GetTimestamp());
    }
}

void TMessageGetIndexPositions::Merge(const IIndexController& index) {
    if (index.GetType() & IndexTypeMask) {
        Positions.Merge(index.GetPositions());
    }
}

TMessageGetIndexPositions::TMessageGetIndexPositions()
    : TMessageGetIndexPositions(IIndexController::FINAL_MASK)
{}
