#pragma once

#include "stream_data.h"

#include <library/cpp/mediator/messenger.h>

class IIndexController;

class TMessageGetTimestamp: public IMessage {
protected:
    NRTYServer::TBaseTimestamp Timestamp;

public:
    const NRTYServer::TBaseTimestamp& GetTimestamp() const {
        return Timestamp;
    }
    void Merge(const NRTYServer::TBaseTimestamp& timestamp) {
        Timestamp.Merge(timestamp);
    }
};

struct TMessageSetTimestamp: public IMessage {
    NRTYServer::TStreamId Stream = 0;
    NRTYServer::TTimestampValue Timestamp = 0;
};

struct TMessageSetDocfetcherTimestamp: public IMessage {
    NRTYServer::TTimestampValue Timestamp = 0;
    bool IncrementOnly = false;
};

class TMessageGetIndexTimestamp: public TMessageGetTimestamp {
private:
    ui16 IndexTypeMask;

public:
    TMessageGetIndexTimestamp();
    explicit TMessageGetIndexTimestamp(ui16 indexTypeMask)
        : IndexTypeMask(indexTypeMask)
    {}

    void Merge(const IIndexController& index);
};

class TMessageGetIndexPositions: public IMessage {
private:
    ui16 IndexTypeMask;
protected:
    NRTYServer::TBasePositions Positions;

public:
    TMessageGetIndexPositions();
    explicit TMessageGetIndexPositions(ui16 indexTypeMask)
        : IndexTypeMask(indexTypeMask)
    {}

    const NRTYServer::TBasePositions& GetPositions() const {
        return Positions;
    }
    void Merge(const IIndexController& index);
};

class TMessageGetSearchableTimestamp: public TMessageGetTimestamp {
};
