#pragma once

#include <library/cpp/json/json_value.h>

#include <util/generic/ptr.h>

class IStructuredInfo {
private:
    const TString Name;

public:
    using TPtr = TAtomicSharedPtr<IStructuredInfo>;

    explicit IStructuredInfo(const TString& name)
        : Name(name)
    {
    }

    virtual ~IStructuredInfo() = default;

    const TString& GetName() const {
        return Name;
    }

    virtual NJson::TJsonValue Serialize() const = 0;
};

