#pragma once

#include <util/system/defaults.h>
#include <util/system/types.h>

#pragma pack(push, 1)
struct TArrayAnnRecord {
    inline TArrayAnnRecord() = default;

    inline TArrayAnnRecord(ui32 breuk, ui32 region, ui32 category, ui32 stream, ui32 value)
        : Stream(stream)
        , Category(category)
        , Region(region)
        , Break(breuk)
        , Value(value)
    {}

    ui64 SearchKey() const {
#ifndef _little_endian_
#   error Treating TArrayAnnRecord as ui64 works only on little endian architectures.
#endif
        return *reinterpret_cast<const ui64*>(this);
    }

    ui8 Stream = 0;
    ui8 Category = 0;
    ui32 Region = 0;
    ui16 Break = 0;
    ui32 Value = 0;
};
static_assert(sizeof(TArrayAnnRecord) == 12, "Expecting TArrayAnnRecord to take up 12 bytes.");
#pragma pack(pop)

struct TArrayAnnRecordLess {
    bool operator()(const TArrayAnnRecord& l, const TArrayAnnRecord& r) const {
        return l.SearchKey() < r.SearchKey();
    }
};
