#pragma once

#include "const.h"

#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/indexer_core/normalizer.h>

class TAnnComponentConfig;

class TAnnComponent: public NRTYServer::IIndexComponent {
private:
    const TRTYServerConfig& Config;
    const TAnnComponentConfig* ComponentConfig;

    TIndexFiles IndexFiles;
    NRTYServer::TNormalizersCollection Normalizers;

public:
    explicit TAnnComponent(const TRTYServerConfig& config);

    TString GetName() const override {
        return NRTYServer::AnnComponentName;
    }

    bool DoMerge(const NRTYServer::TMergeContext& context) const override;
    bool DoMergeMeta(const NRTYServer::TMergeContext& context) const override;
    const TIndexFiles& GetIndexFiles() const override;

    THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    NRTYServer::IComponentParser::TPtr BuildParser() const override;
    NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;

    virtual bool CheckAlways() const override;
    virtual bool DoAllRight(const NRTYServer::TNormalizerContext& context) const override;
    virtual void CheckAndFix(const NRTYServer::TNormalizerContext& context) const override;
    virtual bool CheckConfig() const override;
private:
    static TFactory::TRegistrator<TAnnComponent> Registrator;
};

