#include "config.h"

#include <library/cpp/yconf/conf.h>

bool TAnnComponentConfig::DoCheck() const {
    if (DefaultLanguage == LANG_MAX && RecognizerDataPath == "NOTSET") {
        ERROR_LOG << "Should be one of DefaultLanguage or RecognizerDataPath be defined" << Endl;
        return false;
    }

    return true;
}

void TAnnComponentConfig::DoInit(const TYandexConfig::Section& componentSection) {
    TYandexConfig::TSectionsMap children = componentSection.GetAllChildren();
    TYandexConfig::Directives directives = componentSection.GetDirectives();
    TYandexConfig::TSectionsMap::const_iterator def = children.find("MultipartConfig");
    if (def != children.end()) {
        MultipartConfig.Init(*def->second);
    }

    DataType = directives.Value("DataType", DataType);
    RecognizerDataPath = directives.Value("RecognizerDataPath", RecognizerDataPath);
    SkipUnknownStreams = directives.Value("SkipUnknownStreams", SkipUnknownStreams);
    MapStreamIdToIndex = directives.Value("MapStreamIdToIndex", MapStreamIdToIndex);
    DefaultLanguage = LanguageByNameStrict(directives.Value("DefaultLanguage", TString(NameByLanguage(DefaultLanguage))));
    ImitateQrQuorum = directives.Value("ImitateQrQuorum", ImitateQrQuorum);
    FactorAnnHitsLimit = directives.Value("FactorAnnHitsLimit", FactorAnnHitsLimit);

    //TODO(yrum): set UseExternalCalcer = true for all services
    UseExternalCalcer = directives.Value("UseExternalCalcer", UseExternalCalcer);
    UseRegionChain = directives.Value("UseRegionChain", UseRegionChain);
}

void TAnnComponentConfig::DoToString(IOutputStream& so) const {
    so << MultipartConfig.ToString("MultipartConfig") << Endl;
    so << "DataType: " << DataType << Endl;
    so << "RecognizerDataPath: " << RecognizerDataPath << Endl;
    so << "DefaultLanguage: " << TString(NameByLanguage(DefaultLanguage)) << Endl;
    so << "SkipUnknownStreams: " << SkipUnknownStreams << Endl;
    so << "MapStreamIdToIndex: " << MapStreamIdToIndex << Endl;
    so << "ImitateQrQuorum: " << ImitateQrQuorum << Endl;
    so << "FactorAnnHitsLimit: " << FactorAnnHitsLimit << Endl;
    so << "UseExternalCalcer: " << UseExternalCalcer << Endl;
    so << "UseRegionChain: " << UseRegionChain << Endl;
}
