#pragma once

#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/config/config.h>
#include <saas/rtyserver/components/ann/storage/interfaces.h>

#include <kernel/multipart_archive/config/config.h>

class TAnnComponentConfig: public TPluginConfig<TRTYServerConfig::IComponentConfig> {
protected:
    virtual bool DoCheck() const;
    virtual void DoInit(const TYandexConfig::Section& componentSection);
    virtual void DoToString(IOutputStream& so) const;

public:
    NRTYArchive::TMultipartConfig MultipartConfig;
    NRTYAnn::EDataFormat DataType = NRTYAnn::EDataFormat::PLAIN_ARRAY;
    ELanguage DefaultLanguage = LANG_MAX;
    TString RecognizerDataPath = "NOTSET";
    bool SkipUnknownStreams = false;
    bool MapStreamIdToIndex = true;
    bool ImitateQrQuorum = false; // "new" mode
    ui32 FactorAnnHitsLimit = 0; // SAASSUP-1810
    bool UseExternalCalcer = false; // SAASSUP-2674
    bool UseRegionChain = false; // SAASSUP-2674
};
