#pragma once

#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/components/ann/storage/interfaces.h>
#include <kernel/multipart_archive/multipart.h>

#include <kernel/indexann/interface/reader.h>

class TSentenceLengthsReader;
class TAnnComponentConfig;

namespace NRTYAnn {
    class TAnnDataAccessor;
}

class TAnnIndexManager: public NRTYServer::IIndexComponentManager {
private:
    const TAnnComponentConfig* Config;
    const NRTYFactors::TConfig& Factors;
    const TFsPath Directory;
    bool IsReadOnly;
    THashMap<TString, TArchiveOwner::TPtr> DataStorages;

public:
    TAnnIndexManager(const NRTYServer::TManagerConstructionContext& context, const TString& componentName);
    ~TAnnIndexManager();

    const TAnnComponentConfig& GetConfig() const {
        CHECK_WITH_LOG(Config);
        return *Config;
    }

    const NRTYFactors::TConfig& GetFactors() const {
        return Factors;
    }

    virtual bool UpdateDoc(ui32 /*docId*/, const TAtomicSharedPtr<TParsedDocument> /*doc*/) override {
        return true;
    }

    virtual void InitInteractions(const NRTYServer::IIndexManagersStorage& storage) override;
    virtual ui32 RemoveDocids(const TVector<ui32>& docids) override;
    virtual ui32 GetDocumentsCount() const override;

    virtual bool GetDocInfo(const ui32 docId, NJson::TJsonValue& result) const override;

    virtual bool DoOpen() override;
    virtual bool DoClose() override;

    TArchiveOwner::TPtr GetDataStorage(const TString& type) const;
    TAtomicSharedPtr<NRTYAnn::TAnnDataAccessor> GetDataBlockAccessor(const TString& type) const;

public:
    bool HasType(const TString& dest) const;
    ui32 GetFactorAnnHitsLimit() const;

private:
    bool GetDocInfo(const ui32 docId, const TString& type, NJson::TJsonValue& result) const;
};

class TRTYAnnReader: public NIndexAnn::IDocDataIndex, public NRTYAnn::IDocBlobAccessor, public NRTYAnn::IStreamIdRemapper {
private:
    const TAnnIndexManager* Manager;
    TString StreamIndex;
protected:
    virtual THolder<NIndexAnn::IDocDataIterator> DoCreateIterator() const override;
public:
    TRTYAnnReader(const TAnnIndexManager* manager, const TString& streamIndex);

    virtual bool HasDoc(ui32 doc) const override;
    virtual TBlob Get(ui32 doc) const override;
    virtual ui32 GetGlobalStreamIndex(ui32 streamId) const override;
};
