#pragma once

#include <saas/rtyserver/components/ann/storage/interfaces.h>
#include <saas/rtyserver/indexer_core/normalizer.h>

class TAnnDataFormatNormalizer : public NRTYServer::INormalizer {
public:
    TAnnDataFormatNormalizer(const TRTYServerConfig& config, const NRTYArchive::TMultipartConfig& multipartConfig, NRTYAnn::EDataFormat format, const TString& suffix)
        : NRTYServer::INormalizer(config)
        , MultipartConfig(multipartConfig)
        , Format(format)
        , Suffix(suffix)
        , NormName("AnnDataFormat_" + suffix)
    {}

    virtual const char* Name() const {
        return NormName.data();
    }
    virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;
    virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;

    static NRTYAnn::EDataFormat GetFormat(const TIndexMetadataProcessor& meta, const TString& suffix);

private:
    NRTYAnn::EDataFormat GetFormat(const NRTYServer::TNormalizerContext& context) const;
    void ConvertData(const NRTYServer::TNormalizerContext& context) const;

private:
    const NRTYArchive::TMultipartConfig& MultipartConfig;
    const NRTYAnn::EDataFormat Format;
    TString Suffix;
    TString NormName;
};
