#include "stub.h"

#include <saas/rtyserver/key_inv_processor/ki_maker.h>

bool TStubAnnotationsNormalizer::AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /*indexFrq*/) const {
    return HasAnnotations(context);
}

void TStubAnnotationsNormalizer::Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& /*indexFrq*/) const {
    if (!HasAnnotations(context)) {
        CreateStubAnnotations(context);
    }
}

bool TStubAnnotationsNormalizer::HasAnnotations(const NRTYServer::TNormalizerContext& context) const {
    const TFsPath path = TFsPath(context.Dir.PathName()) / ("index" + Suffix + ".fat");
    return path.Exists();
}

void TStubAnnotationsNormalizer::CreateStubAnnotations(const NRTYServer::TNormalizerContext& context) const {
    const TFsPath root = context.Dir.PathName();
    {
        TRTYKIMaker kimaker(1, root, "index" + Suffix + ".", 1);
        kimaker.Start();
        kimaker.Stop();
        kimaker.Close(nullptr);
    }
    {
        TSentenceLengthsWriter sentenceLengthsWriter(root / "index" + Suffix + ".sent");
    }
    {
        const auto data = root / ("index" + Suffix + ".fat");
        data.Touch();
    }
}
