#pragma once

#include <saas/rtyserver/indexer_core/normalizer.h>

class TStubAnnotationsNormalizer: public NRTYServer::INormalizer {
public:
    TStubAnnotationsNormalizer(const TRTYServerConfig& config, const TString& suffix)
        : NRTYServer::INormalizer(config)
        , Suffix(suffix)
        , NormName("StubAnnotations_" + suffix)
    {}

    virtual const char* Name() const {
        return NormName.data();
    }

    virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;
    virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;

private:
    bool HasAnnotations(const NRTYServer::TNormalizerContext& context) const;
    void CreateStubAnnotations(const NRTYServer::TNormalizerContext& context) const;

private:
    TString Suffix;
    TString NormName;
};
