#pragma once

#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/indexer_core/document_parser.h>
#include <saas/rtyserver/factors/factors_blocks.h>
#include <util/generic/array_ref.h>

class TAnnComponentConfig;


class TAnnParsedEntity: public TParsedDocument::TParsedEntity {
public:
    struct TStream {
        TString Destination;
        TString Data;
        ui32 Index;

        TStream(const TString& dest, const TString& data, ui32 index)
            : Destination(dest)
            , Data(data)
            , Index(index)
        {}
    };

    using TStreamsStorage = TVector<TStream>;

    class TSentenceData {
    private:
        TUtf16String Sentence;
        TMap<ui32, TStreamsStorage> Regions;
        TSet<TString> Destinations;
        TMaybe<ELanguage> TextLanguage;

    public:
        TSentenceData()
        {}

        bool Parse(const NRTYServer::TMessage::TSentenceData& protoData,
            const NRTYFactors::TAnnFactorsHashList& annFactorsData,
            bool skipUnknownStreams,
            bool mapStreamId);

        const TUtf16String& GetSentence() const {
            return Sentence;
        }

        const TMap<ui32, TStreamsStorage>& GetRegions() const {
            return Regions;
        }

        const TSet<TString>& GetDestinations() const  {
            return Destinations;
        }

        TMaybe<ELanguage> GetTextLanguage() const {
            return TextLanguage;
        }
    };
private:
    TVector<TSentenceData> Sentences;
    const NRTYFactors::TAnnFactorsHashList& AnnStreamsInfo;
public:
    TAnnParsedEntity(TConstructParams& params);

    const NRTYFactors::TAnnFactorsHashList& GetAnnData() {
        return AnnStreamsInfo;
    }

    void AddSentenceInfo(const TSentenceData& data) {
        Sentences.push_back(data);
    }

    const TVector<TSentenceData>& GetSentences() const {
        return Sentences;
    }
};

class TAnnComponentParser: public TComponentParser {
private:
    const TAnnComponentConfig* Config;

public:
    explicit TAnnComponentParser(const TRTYServerConfig& config);
    virtual void Parse(TParsingContext& context) const;
};
