#pragma once

#include <util/generic/array_ref.h>
#include <util/memory/blob.h>

namespace NRTYAnn {
    enum class EDataFormat {
        COMPTRIE,  // use carefully, read more: SAASSUP-4278
        PLAIN_ARRAY
    };

    class IStreamIdRemapper {
    public:
        virtual ~IStreamIdRemapper() {};
        virtual ui32 GetGlobalStreamIndex(ui32 streamId) const = 0;
    };

    class IDocBlobAccessor {
    public:
        virtual ~IDocBlobAccessor() {}
        virtual TBlob Get(ui32 docId) const = 0;
    };

    class IDataBlockAccessor {
    public:
        IDataBlockAccessor(ui32 size)
            : BlockBegining(nullptr)
            , Size(size)
        {}

        ui32 GetSize() const {
            return Size;
        }

        void SetBlockBegining(char* begin) const {
            BlockBegining = begin;
        }

        virtual TArrayRef<const char> Get(ui32 index) const = 0;
        virtual ui32 GetDataCount() const = 0;
        virtual bool Set(ui32 index, const TArrayRef<const char>& data) = 0;
        virtual ~IDataBlockAccessor() {}

    protected:
        mutable char* BlockBegining;
        const ui32 Size;
    };
}
