#pragma once

#include "interfaces.h"

#include <kernel/indexann/interface/reader.h>
#include <util/memory/blob.h>
#include <util/generic/ptr.h>


namespace NRTYAnn {

    class TStreamIterator : public NIndexAnn::IDocDataIterator {
    public:
        TStreamIterator(const IDocBlobAccessor* docAccessor, TAtomicSharedPtr<IDataBlockAccessor> dataAccessor, const IStreamIdRemapper* remapper = nullptr);

        virtual const NIndexAnn::THit& Current() const override;
        virtual bool Valid() const override;
        virtual const NIndexAnn::THit* Next() override;
        virtual void Restart(const NIndexAnn::THitMask& mask) override;

        virtual ~TStreamIterator() override;

    private:
        THolder<class TStreamIteratorImpl> Impl;
    };
}
