#pragma once

#include <library/cpp/containers/comptrie/comptrie.h>
#include <util/stream/str.h>


namespace NRTYAnn {

    struct TStreamDataHeader {
        ui32 Size = 0;

        TStreamDataHeader()
            : Size(0)
        {}
    };

    template<size_t N>
    class TFixedSizeKey: public std::array<ui32, N> {
        using TBase = std::array<ui32, N>;
    public:
        TFixedSizeKey()
            : TBase()
            , Pos(0)
        {
            TBase::fill(0);
        }

        TFixedSizeKey(const ui32* extData, ui32 len)
            : TBase()
            , Pos(len)
        {
            Y_ASSERT(Pos <= N);
            TBase::fill(0);
            memcpy(TBase::data(), extData, sizeof(ui32) * len);
        }

        TFixedSizeKey(const TFixedSizeKey& other)
            : Pos(other.Pos)
        {
            Y_ASSERT(Pos <= N);
            TBase::fill(0);
            memcpy(TBase::data(), other.data(), sizeof(ui32) * other.size());
        }

        TFixedSizeKey& Set(ui32 index, ui32 val) {
            Y_ASSERT(index < N);
            (*this)[index] = val;
            return *this;
        }

        TString Quote() const {
            TStringStream out;
            out << "{";
            out << TBase::data()[0];
            for (ui32 i = 1; i < TBase::size(); ++i) {
                out << ", " << TBase::data()[i];
            }
            out << "}";
            return out.Str();
        }

        // For TCompactTrie::TKeyBuf template type.
        void reserve(size_t rs) {
            Y_ASSERT(rs <= N);
        }

        // For TCompactTrie::TKeyBuf template type.
        void push_back(ui32 val) {
            Y_ASSERT(Pos != N);
            (*this)[Pos++] = val;
        }

    private:
        ui32 Pos;
    };
}
