#pragma once

#include "key.h"
#include "interfaces.h"

#include <kernel/multipart_archive/multipart.h>
#include <kernel/multipart_archive/config/config.h>
#include <kernel/indexann/interface/writer.h>
#include <library/cpp/containers/comptrie/comptrie.h>


namespace NRTYAnn {

    class TStreamDataWriter : public NIndexAnn::IDocDataWriter {
    public:
        TStreamDataWriter(const TArchiveOwner::TPtr& storage, TAtomicSharedPtr<IDataBlockAccessor> accessor);

        virtual void Add(ui32 breakId, ui32 regionId, ui32 streamId, TArrayRef<const char> data) override;
        virtual void StartDoc(ui32 docId) override;
        virtual void FinishDoc() override;

    private:
        TBlob GetFinalBlob() const;

    private:
        TArchiveOwner::TPtr DocumentsStorage;
        TAtomicSharedPtr<IDataBlockAccessor> DataAccessor;
        THolder<TBuffer> StreamData;
        THolder<TCompactTrieBuilder<ui32, ui32>> IndexBuilder;
        ui32 DocId;
    };
}
