#pragma once

#include "cs_manager.h"
#include "cs_parsed_entity.h"

#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/components/erf/erf_builder.h>
#include <saas/rtyserver/components/erf/erf_writer.h>
#include <saas/rtyserver/config/config.h>
#include <saas/rtyserver/config/common_indexers_config.h>
#include <saas/rtyserver/config/indexer_config.h>
#include <saas/rtyserver/key_inv_processor/ki_maker.h>

class TCSBuilder: public NRTYServer::IIndexComponentBuilder {
private:
    TCSManager* Maker;
    const NRTYServer::TIndexerConfig& Config;
    TString Dir;
public:
    virtual ~TCSBuilder() {}

    TCSBuilder(const TString& dir, const NRTYServer::TIndexerConfig& config, const TString& componentName)
        : NRTYServer::IIndexComponentBuilder(componentName)
        , Config(config)
        , Dir(dir)
    {
        Maker = new TCSManager(Dir, Config.Common.Owner);
    }

    NRTYServer::IIndexComponentManager* GetManager() override { return Maker; }
    void Index(int threadID, const TParsedDocument& document, const ui32 docId) override;
    bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
    bool Start() override;
    bool Stop() override;
    void InitInteractions(const NRTYServer::IIndexBuildersStorage& /*storage*/) override {

    }
};
