#pragma once
#include <saas/rtyserver/config/fwd.h>
#include <saas/rtyserver/factors/factors_blocks.h>
#include <saas/rtyserver/factors/factors_config.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/components/cs/functions/cs_function_abstract.h>

#define CS_COMPONENT_NAME "CS"

class TCSIndexComponent: public NRTYServer::IIndexComponent {
private:
    typedef NRTYFactors::TCSFactorsHashList TCSFactorsInfo;

private:
    const TRTYServerConfig& Config;
    const TCSFactorsInfo& FactorsInfo;
    TIndexFiles IndexFiles;
    typedef TAtomicSharedPtr<ICSFunction> TFunctionPtr;
    typedef THashMap<TString, TFunctionPtr> TFunctionsByName;

public:
    explicit TCSIndexComponent(const TRTYServerConfig& config);
    NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;
    NRTYServer::IComponentParser::TPtr BuildParser() const override;

    bool CheckConfig() const override { return true; }
    bool DoMerge(const NRTYServer::TMergeContext& context) const override;
    const TIndexFiles& GetIndexFiles() const override;
    bool DoAllRight(const NRTYServer::TNormalizerContext& /*context*/) const override {
        return true;
    }

    void CheckAndFix(const NRTYServer::TNormalizerContext& /*context*/) const override {
        return;
    }

    TString GetName() const override {
        return CS_COMPONENT_NAME;
    };

    THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    const ICSFunction& GetFunction(const TString& name) const {
        return *FunctionByName.find(name)->second;
    }
private:
    TFunctionsByName FunctionByName;
    static TFactory::TRegistrator<TCSIndexComponent> Registrator;
};
