#pragma once

#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/key_inv_processor/ki_actor.h>
#include <saas/rtyserver/indexer_core/document_parser.h>
#include <saas/rtyserver/factors/factors_config.h>
#include <saas/rtyserver/components/erf/erf_parsed_entity.h>

class TDocumentCSInfo: public TRTYErfParsedStorage {
private:
    TString FValue;
public:
    void SetFValue(const TString& fvalue) {
        FValue = fvalue;
    }

    void Serialize(NRTYServer::TMessage::TCSInfo& info) const {
        for (ui32 i = 0; i < FactorsInfo->GetStaticFactorsCount(); ++i) {
            info.MutableFactors()->AddNames(FactorsInfo->GetFactor(i).Name);
            info.MutableFactors()->MutableValues()->AddValues()->SetValue(Values[i]);
        }
    }

    const TString& GetFValue() const {
        return FValue;
    }

    void ApplyPatch(const TDocumentCSInfo& patch);
};

class TCSParsedEntity : public TParsedDocument::TParsedEntity {
public:
    typedef THashMap<TString, TDocumentCSInfo> TFactorsByCS;
    TCSParsedEntity(TConstructParams& params);

    virtual void MergeToProto(NRTYServer::TParsedDoc& pd, const NRTYServer::TDocSerializeContext& context) const;
    void AddCSInfo(const NRTYServer::TMessage::TCSInfo& qsInfo, const TParsedDocument& doc,
                   const NRTYFactors::TCSFactorsList::TPtr factorsInfo, bool needInCheckFullFactorsList);
    const TFactorsByCS& GetDocInfos() const {
        return FactorsByCS;
    }
protected:
    virtual void DoApplyPatch(const TParsedDocument& doc);
private:
    TFactorsByCS FactorsByCS;
};

class TCSComponentParser: public TComponentParser {
public:
    virtual void Parse(TParsingContext& context) const;
};
