#include "cs_function_domain.h"
#include <library/cpp/uri/uri.h>
#include <library/cpp/uri/common.h>
#include <saas/rtyserver/indexer_core/parsed_document.h>

TCSFunctionDomain::TFactory::TRegistrator<TCSFunctionDomain> TCSFunctionDomain::Registrator(CS_FUNCTION_DOMAIN);

TString TCSFunctionDomain::GetFResult(const TParsedDocument& parsedDoc) const {
    NUri::TUri uri;
    if (uri.Parse(parsedDoc.GetDocSearchInfo().GetUrl()) == NUri::TState::ParsedOK && !!TString(uri.GetHost())) {
        return TString(uri.GetHost());
    } else
        return parsedDoc.GetDocSearchInfo().GetUrl();
}
