#pragma once

#include <saas/rtyserver/indexer_core/abstract_model.h>

class TRTYErfBuilder;
class TRTYDDKManager;
class TDDKComponentConfig;
struct TDDKMetrics;

class TRTYDDKBuilder: public NRTYServer::IIndexComponentBuilder {
public:
    TRTYDDKBuilder(TRTYErfBuilder* base, const TDDKComponentConfig& config, TDDKMetrics& metrics, const TString& componentName);
    TRTYDDKBuilder(THolder<TRTYErfBuilder> base, const TDDKComponentConfig& config, TDDKMetrics& metrics, const TString& componentName);
    ~TRTYDDKBuilder();

public:
    NRTYServer::IIndexComponentManager* GetManager() override;
    void Index(int threadID, const TParsedDocument& document, const ui32 docId) override;
    bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
    bool Start() override;
    bool Stop() override;
    void InitInteractions(const NRTYServer::IIndexBuildersStorage& storage) override;

private:
    THolder<TRTYErfBuilder> BaseHolder;
    TRTYErfBuilder* Base;
    TRTYDDKManager* Manager;

    TAtomic DocCount;
    TAtomic DocSize;

    const TDDKComponentConfig& Config;
    const bool Merger;
    TDDKMetrics& Metrics;
};
