#include "ddk_config.h"

#include <library/cpp/yconf/conf.h>

bool TDDKComponentConfig::DoCheck() const {
    return true;
}

void TDDKComponentConfig::DoInit(const TYandexConfig::Section& componentSection) {
    DefaultLifetimeMinutes = componentSection.GetDirectives().Value<ui32>("DefaultLifetimeMinutes", 0);
    LifetimeMinutesOffset = componentSection.GetDirectives().Value<i32>("LifetimeMinutesOffset", 0);
    ValidateTimestamp = componentSection.GetDirectives().Value<bool>("ValidateTimestamp", false);
    MaxUpdateAge = componentSection.GetDirectives().Value<ui64>("MaxUpdateAge", TInstant::Days(3).Seconds());
    CheckAlways = componentSection.GetDirectives().Value<bool>("CheckAlways", true);
    LockDDKFile = componentSection.GetDirectives().Value<bool>("LockDDKFile", true);
    EnableLifetimeCheck = componentSection.GetDirectives().Value<bool>("EnableLifetimeCheck", true);
    Enabled = componentSection.GetDirectives().Value<bool>("Enabled", true);
}

void TDDKComponentConfig::DoToString(IOutputStream& so) const {
    so << "DefaultLifetimeMinutes : " << DefaultLifetimeMinutes << Endl;
    so << "LifetimeMinutesOffset : " << LifetimeMinutesOffset << Endl;
    so << "ValidateTimestamp : " << ValidateTimestamp << Endl;
    so << "MaxUpdateAge : " << MaxUpdateAge << Endl;
    so << "CheckAlways : " << CheckAlways << Endl;
    so << "LockDDKFile : " << LockDDKFile << Endl;
    so << "EnableLifetimeCheck : " << EnableLifetimeCheck << Endl;
    so << "Enabled : " << Enabled << Endl;
}
