#pragma once

#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/config/config.h>

class TDDKComponentConfig: public TPluginConfig<TRTYServerConfig::IComponentConfig> {
private:
    ui32 DefaultLifetimeMinutes = 0;
    i32  LifetimeMinutesOffset = 0;
    bool ValidateTimestamp = false;
    ui64 MaxUpdateAge = TInstant::Days(3).Seconds();
    bool CheckAlways = true;
    bool LockDDKFile = true;
    bool EnableLifetimeCheck = true;
    bool Enabled = true;

protected:
    virtual bool DoCheck() const;
    virtual void DoInit(const TYandexConfig::Section& componentSection);
    virtual void DoToString(IOutputStream& so) const;

public:
    ui32 GetDefaultLifetimeMinutes() const {
        return DefaultLifetimeMinutes;
    }

    i32 GetLifetimeMinutesOffset() const {
        return LifetimeMinutesOffset;
    }

    bool GetValidateTimestamp() const {
        return ValidateTimestamp;
    }

    ui64 GetMaxUpdateAge() const {
        return MaxUpdateAge;
    }

    bool GetCheckAlways() const {
        return CheckAlways;
    }

    bool GetLockDDKFile() const {
        return LockDDKFile;
    }

    bool GetEnableLifetimeCheck() const {
        return EnableLifetimeCheck;
    }

    bool GetEnabled() const {
        return Enabled;
    }
};
