#pragma once

#include <saas/rtyserver/common/doc_search_info.h>

namespace NRTYServer {

namespace NDDK {
    constexpr size_t DeadlineIndex = 0;
    constexpr size_t VersionIndex = 1;
    constexpr size_t TimestampIndex = 2;
    constexpr size_t HashIndex = 3;

    constexpr size_t HashFields = (TDocSearchInfo::THash::Size / sizeof(float));

    constexpr size_t SourceWithNewVersionIndex = HashIndex + HashFields;
    constexpr size_t ParsedEntitiesHashIndex = SourceWithNewVersionIndex + 1;
    constexpr size_t StreamIdIndex = ParsedEntitiesHashIndex + 1;
    constexpr size_t KeysCount = StreamIdIndex + 1;
}

}

class IRTYStaticFactors;
class TBasicFactorStorage;

const IRTYStaticFactors& GetDDKFields();
void SetHash(TBasicFactorStorage& ddkBlock, const TDocSearchInfo& info);
