#pragma once

#include <saas/rtyserver/indexer_core/parsed_document.h>
#include <saas/rtyserver/indexer_core/document_parser.h>

#include <util/generic/maybe.h>

class TDDKComponentConfig;

class TRTYDDKParsedEntity : public TParsedDocument::TParsedEntity {
public:
    TRTYDDKParsedEntity(TConstructParams& params);

    ui32 GetDeadlineMinutesUTC() const {
        return DeadlineMinutesUTC.GetOrElse(0);
    }
    bool HasDeadlineMinutesUTC() const noexcept {
        return DeadlineMinutesUTC.Defined();
    }
    void SetDeadlineMinutesUTC(ui32 value) {
        DeadlineMinutesUTC = value;
    }

    ui32 GetTimestampUTC() const {
        return TimestampUTC;
    }
    void SetTimestampUTC(ui32 value) {
        TimestampUTC = value;
    }

    ui32 GetVersion() const {
        return Version;
    }
    void SetVersion(ui32 value) {
        Version = value;
    }

    ui32 GetSize() const {
        return Size;
    }
    void SetSize(ui32 value) {
        Size = value;
    }

    ui32 GetStreamId() const {
        return StreamId;
    }
    void SetStreamId(ui32 value) {
        StreamId = value;
    }

    ui32 GetHash() const override ;
    void MergeToProto(NRTYServer::TParsedDoc& pd, const NRTYServer::TDocSerializeContext& context) const override;

protected:
    virtual void DoApplyPatch(const TParsedDocument& doc) override;

private:
    TMaybe<ui32> DeadlineMinutesUTC;
    ui32 TimestampUTC;
    ui32 Version;
    ui32 Size;
    ui32 StreamId;
};

class TRTYDDKComponentParser : public TComponentParser {
public:
    explicit TRTYDDKComponentParser(const TDDKComponentConfig& config);
    virtual void Parse(TParsingContext& context) const;

private:
    const TDDKComponentConfig& ComponentConfig;
    const size_t StreamLimit;
};
