#pragma once

#include <saas/library/daemon_base/metrics/metrics.h>

struct TDDKMetrics: public TCompositeMetric {
    TPart<TOrangeMetric> DocumentSize;
    TPart<TAgeHistogramMetrics> DocumentAgeHour;
    TPart<TAgeHistogramMetrics> DocumentAgeDay;

    TDDKMetrics()
        : DocumentSize(this, GetMetricsPrefix() + "DiskIndex_DocumentSizeAvg")
        , DocumentAgeHour(this, GetMetricsPrefix() + "DiskIndex_DocAge_Hour", GetMetricsMaxAgeDays() ? 24 : 0)
        , DocumentAgeDay(this, GetMetricsPrefix() + "DiskIndex_DocAge_Day", GetMetricsMaxAgeDays())
    {
    }
};
