#pragma once

#include "const.h"
#include "manager.h"
#include "merger.h"
#include <robot/jupiter/library/rtdoc/file/model/interfaces.h>
#include <dj/lib/shard2/rty/prep_builder.h>
#include <dj/lib/shard2/rty/index_builder.h>

#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <util/system/mutex.h>

namespace NRTYServer {
    class TDjBuilder final : public IIndexComponentBuilder {
    public:
        TDjBuilder(
                const TString& indexFilesPrefix,
                const NDJ::NShard::TSearchIndexBuilder* builder,
                const bool keepPrepFiles);

        void Index(int threadId, const TParsedDocument& document, const ui32 docId) override;

        bool DoClose(const TBuilderCloseContext& context) override;

        bool Start() override {
            return true;
        }

        bool Stop() override {
            return true;
        }

        void InitInteractions(const IIndexBuildersStorage& /*storage*/) override {
        }

        IIndexComponentManager* GetManager() override {
            return Manager;
        }

    private:
        NDJ::NShard::TPrepBuilder Builder;
        TDjComponentManager* Manager;
        const NDJ::NShard::TSearchIndexBuilder* SearchIndexBuilder;
        const bool KeepPrepFiles;
    };
}
