#pragma once

#include "const.h"
#include "merger.h"

#include <saas/rtyserver/indexer_core/abstract_model.h>

#include <dj/lib/shard2/rty/index_builder.h>

namespace NRTYServer {
    class TDjComponent final : public IIndexComponent {
    public:
        explicit TDjComponent(const TRTYServerConfig& config);

        TString GetName() const override { return DjComponentName; }

        bool CheckAlways() const override { return true; }

        const IIndexFilesGroup::TIndexFiles& GetIndexFiles() const override {
            return IndexFiles;
        }

        THolder<IIndexComponentBuilder> CreateBuilder(const TBuilderConstructionContext& context) const override;
        THolder<IIndexComponentManager> CreateManager(const TManagerConstructionContext& context) const override;
        IComponentParser::TPtr BuildParser() const override;
        IParsedEntity::TPtr BuildParsedEntity(IParsedEntity::TConstructParams& params) const override;

    protected:
        bool DoMerge(const TMergeContext& context) const override;
        void CheckAndFix(const TNormalizerContext& /*context*/) const override;
        bool DoAllRight(const TNormalizerContext& /*context*/) const override;

        NDJ::TShardBuilderConfig ShardBuilderConfig;
        TIndexFiles IndexFiles; // empty
        const TRTYServerConfig* Config;
        TMaybe<NDJ::NShard::TSearchIndexBuilder> SearchIndexBuilder;
        TMaybe<TDjMerger> Merger;
        bool TryToRepair;

    private:
        static TFactory::TRegistrator<TDjComponent> Registrator;
    };

}
