#pragma once

#include "const.h"

#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <util/system/yassert.h>

namespace NRTYServer {
    class TDjComponentManager final : public NRTYServer::IIndexComponentManager
    {
        THashSet<ui32> DeletedDocids;
    public:

        TDjComponentManager()
            : NRTYServer::IIndexComponentManager(DjComponentName)
        {
        }

        const THashSet<ui32>& GetDeletedDocids() const { return DeletedDocids; }

        bool GetDocInfo(const ui32 /*docId*/, NJson::TJsonValue& /*result*/) const override {
            return true;
        }
        ui32 GetDocumentsCount() const override { return Max<ui32>(); }

        void InitInteractions(const NRTYServer::IIndexManagersStorage& /* storage */) override {}

        bool UpdateDoc(ui32 /*docId*/, const TParsedDocument::TPtr /*doc*/) override {
            return false;
        }

        ui32 RemoveDocids(const TVector<ui32>& docids) override;

        bool DoOpen() override { return true; }

        bool DoClose() override { return true; }
    };
}

