#include "const.h"
#include "parsed_entity.h"
#include "const.h"

#include <dj/lib/shard2/rty/lumps.h>

namespace NRTYServer {
    void TDjDocParser::Parse(TParsingContext& context) const {
        auto* result = context.Result.GetComponentEntity<TDjParsedEntity>(DjComponentName);
        VERIFY_WITH_LOG(result, "TDjParsedEntity is missing");

        if (Y_UNLIKELY(!context.Document.HasIndexedDoc())) {
            return;
        }

        *result->MutableData() = NDJ::NShard::GetWadLumps(context.Document.GetIndexedDoc());
    }
}
