#pragma once

#include <robot/jupiter/library/rtdoc/protos/lumps.pb.h>
#include <saas/rtyserver/indexer_core/document_parser.h>
#include <util/system/yassert.h>

namespace NRTYServer {
    class TDjParsedEntity final : public TParsedDocument::TParsedEntity {
    public:
        using TParsedDocument::TParsedEntity::TParsedEntity;

        const NJupiter::TMercuryLumps* GetData() const { return &Data; }
        NJupiter::TMercuryLumps* MutableData() { return &Data; }

    protected:
        virtual void DoApplyPatch(const TParsedDocument& /*doc*/) { Y_FAIL(); }

    private:
        NJupiter::TMercuryLumps Data;
    };

    class TDjDocParser final : public TComponentParser {
    public:
        void Parse(TParsingContext& context) const override;
    };
}
