#pragma once

#include "globals.h"
#include "dssm_manager.h"

#include <saas/rtyserver/components/l2/l2_builder.h>
#include <saas/rtyserver/components/l2/l2_core.h>
#include <saas/rtyserver/components/l2/l2_memory_manager.h>
#include <saas/rtyserver/components/l2/l2_normalizer.h>
#include <saas/rtyserver/components/l2/l2_parser.h>

namespace NRTYServer {
    class TDssmParser: public TL2ComponentParserBase {
    public:
        using TL2ComponentParserBase::TL2ComponentParserBase;

        void Parse(TParsingContext& context) const override;
    };

    class TDssmCore: public IL2ComponentCore {
    public:
        using TDiskManager = TDssmManager;
        using TBuilder = TL2ComponentBuilder;
        using TDocEntity = TRTYFullArchiveLightEntity;
        using TParser = TDssmParser;
        using TNormalizer = TL2Normalizer;

    public:
        TStringBuf GetName() const override {
            return DssmComponentName;
        }
    };
} // namespace NRTYServer
