#pragma once

#include "erf_disk.h"
#include "erf_writer.h"

#include <saas/rtyserver/indexer_core/indexer_core.h>

class TParsedDocument;

class TRTYErfBuilder: public NRTYServer::IIndexComponentBuilder {
protected:
    IRTYErfManager* ErfManager;
    TErfWriter ErfWriter;
    const IRTYStaticFactors* StaticFactors;

public:
    TRTYErfBuilder(IRTYErfManager* manager, const TString& componentName);
    virtual ~TRTYErfBuilder();

    IRTYErfManager* GetErfManager() const {
        return ErfManager;
    }
public: // NRTYServer::IIndexComponentBuilder
    NRTYServer::IIndexComponentManager* GetManager() override { return ErfManager; }
    void Index(int threadID, const TParsedDocument& document, const ui32 docId) override;
    bool DoClose(const NRTYServer::TBuilderCloseContext& /* context */) override;
    bool Start() override { return true; }
    bool Stop() override { return true; }
    void InitInteractions(const NRTYServer::IIndexBuildersStorage& /*storage*/) override {}
};

class TRTYMemoryErfBuilder: public TRTYErfBuilder {
public:
    TRTYMemoryErfBuilder(IRTYErfManager* manager, const TString& componentName);
    bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
};

class TRTYDiskErfBuilder: public TRTYErfBuilder {
private:
    TRTYErfDiskManager::TCreationContext DiskManagerCtx;

public:
    TRTYDiskErfBuilder(IRTYErfManager* manager, const TRTYErfDiskManager::TCreationContext& diskManagerCtx, const TString& componentName);
    bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
};
