#pragma once

#include "erf_global.h"

#include <saas/rtyserver/config/fwd.h>
#include <saas/rtyserver/config/const.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>

class IRTYStaticFactors;

namespace NRTYFactors {
    class TRankModelHolder;
}

class TRTYErfIndexComponent: public NRTYServer::IIndexComponent {
protected:
    const TRTYServerConfig& Config;
    const IRTYStaticFactors& StaticFactors;
    const TString BaseFileName;

    TIndexFiles IndexFiles;

public:
    TRTYErfIndexComponent(const TRTYServerConfig& config, bool isUsed, const TString& fileName, const IRTYStaticFactors& staticFactors);
    TRTYErfIndexComponent(const TRTYServerConfig& config, const TString& fileName, const IRTYStaticFactors& staticFactors);

    const TRTYServerConfig& GetConfig() const {
        return Config;
    }
    THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    NRTYServer::IComponentParser::TPtr BuildParser() const override;
    NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;
    const TIndexFiles& GetIndexFiles() const override;

    bool DoMerge(const NRTYServer::TMergeContext& rtyContext) const override;
    bool DoAllRight(const NRTYServer::TNormalizerContext& context) const override;
    void CheckAndFix(const NRTYServer::TNormalizerContext& context) const override;
    bool GetInfoChecker(NRTYServer::TInfoChecker& info) const override;

    TPriorityInfo GetPriority() const override {
        TPriorityInfo result = IIndexComponent::GetPriority();
        result.ComponentPriority = ERF_COMPONENT_PRIORITY;
        return result;
    }

public:
    const NRTYFactors::TRankModelHolder* GetPruningFormula() const;
    const IRTYStaticFactors& GetStaticFactors() const;
};

class TRTYStaticFactorsConfigHolder {
protected:
    explicit TRTYStaticFactorsConfigHolder(THolder<IRTYStaticFactors> factorsConfig);
    virtual ~TRTYStaticFactorsConfigHolder();

    THolder<IRTYStaticFactors> FactorsConfig;
};

class TRTYStaticErfIndexComponent: private TRTYStaticFactorsConfigHolder, public TRTYErfIndexComponent {
public:
    TRTYStaticErfIndexComponent(const TRTYServerConfig& config);
    TString GetName() const override {
        return ERF_COMPONENT_NAME;
    }
    THolder<TPruningConfig::ICalcer> CreatePruningCalcer(const NRTYServer::IIndexManagersStorage* managers) const override;
private:
    static TFactory::TRegistrator<TRTYStaticErfIndexComponent> Registrator;
};
