#pragma once

#include <saas/rtyserver/indexer_core/abstract_model.h>

#include <kernel/factor_storage/factor_storage.h>

class TParsedDocument;
class IRTYStaticFactors;

class IRTYErfReader {
public:
    virtual ~IRTYErfReader() {}

    virtual bool Read(TFactorView& factors, ui32 position) const = 0;
    virtual bool ReadRaw(TBasicFactorStorage& erfBlock, ui32 position) const = 0;
    virtual ui32 Size() const = 0;

    bool GetErfDocInfo(const IRTYStaticFactors* factors, const ui32 docId, NJson::TJsonValue& result) const;
};

class IRTYErfManager: public NRTYServer::IIndexComponentManager,
                      public IRTYErfReader
{
public:
    virtual ~IRTYErfManager() {};

    IRTYErfManager(const TString& componentName);
    virtual const IRTYStaticFactors* GetFactorsInfo() const = 0;
    virtual bool Write(const TBasicFactorStorage& data, ui32 position) const = 0;
    virtual bool Resize() = 0;
    virtual ui32 BlockSizeBytes() const = 0;
    virtual bool GetDocInfo(const ui32 docId, NJson::TJsonValue& result) const;
    virtual bool UpdateDoc(ui32 docId, const TParsedDocument::TPtr doc);
    virtual bool IsStatic() const { return false; }
    virtual bool RemapRequired() const { return false; }

    const TString& GetComponentName() const {
        return ComponentName;
    }
};

typedef TAtomicSharedPtr<IRTYErfManager> IRTYErfManagerPtr;
