#pragma once

#include "erf_manager.h"
#include <saas/rtyserver/factors/factors_abstract.h>
#include <util/generic/buffer.h>

class TRTYErfMemoryManager: public IRTYErfManager {
private:
    const IRTYStaticFactors* FDescription;
    mutable TBuffer Storage;
    TErfBitsRemapper Remapper;

public:
    TRTYErfMemoryManager(ui32 blocksCountStart, const IRTYStaticFactors* fDescription, const TString& componentName);

public: // IRTYErfManager
    const IRTYStaticFactors* GetFactorsInfo() const override {
        return FDescription;
    }

    bool Write(const TBasicFactorStorage& erfBlock, ui32 docId) const override;
    bool ReadRaw(TBasicFactorStorage& erfBlock, ui32 docId) const override;
    bool Read(TFactorView& data, ui32 docId) const override;

    bool Resize() override;
    ui32 Size() const override;
    ui32 BlockSizeBytes() const override;

public: // NRTYServer::IIndexComponentManager
    bool DoOpen() override { return true; }
    bool DoClose() override { return true; }
    ui32 GetDocumentsCount() const override { return Size(); }
    void InitInteractions(const NRTYServer::IIndexManagersStorage& /* storage */) override {}
};
