#pragma once

#include <saas/rtyserver/indexer_core/abstract_model.h>

class TRTYFastArchiveConfig;

class TRTYFastArchive : public NRTYServer::IIndexComponent {
protected:
    const TRTYServerConfig& Config;
    const TRTYFastArchiveConfig* ComponentConfig;
    TIndexFiles IndexFiles;
public:
    explicit TRTYFastArchive(const TRTYServerConfig& config);

    THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    NRTYServer::IComponentParser::TPtr BuildParser() const override;
    NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;
    TString GetName() const override;

    const TIndexFiles& GetIndexFiles() const override {
        return IndexFiles;
    }

    bool DoMerge(const NRTYServer::TMergeContext& rtyContext) const override;
    bool DoAllRight(const NRTYServer::TNormalizerContext& /*context*/) const override;
    void CheckAndFix(const NRTYServer::TNormalizerContext& /*context*/) const override;
    bool GetInfoChecker(NRTYServer::TInfoChecker& info) const override;

    static NRTYServer::IIndexComponent::TFactory::TRegistrator<TRTYFastArchive> Registrator;
};
