#include "config.h"
#include <util/string/split.h>

bool TRTYFastArchiveConfig::DoCheck() const {
    return true;
}

void TRTYFastArchiveConfig::DoInit(const TYandexConfig::Section& componentSection) {
    TString fastProperties;
    if (componentSection.GetDirectives().GetValue("FastProperties", fastProperties)) {
        const TVector<TString> properties = StringSplitter(fastProperties).SplitBySet(", ").SkipEmpty();
        FastProperties.insert(properties.begin(), properties.end());
    }
}

void TRTYFastArchiveConfig::DoToString(IOutputStream& so) const {
    so << "FastProperties : " << JoinStrings(FastProperties.begin(), FastProperties.end(), ",") << Endl;
}
