#pragma once

#include <util/generic/set.h>
#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/config/config.h>

class TRTYFastArchiveConfig : public TPluginConfig<TRTYServerConfig::IComponentConfig> {
private:
    TSet<TString> FastProperties;

protected:
    virtual bool DoCheck() const;
    virtual void DoInit(const TYandexConfig::Section& componentSection);
    virtual void DoToString(IOutputStream& so) const;

public:
    const TSet<TString>& GetFastProperties() const {
        return FastProperties;
    }
    static TRTYServerConfig::IComponentConfig::TFactory::TRegistrator<TRTYFastArchiveConfig> ConfigRegistrator;
};
