#pragma once

#include "archive.h"

#include <saas/rtyserver/indexer_core/abstract_model.h>
#include "globals.h"

class TParsedDocument;
class TRTYFastArchiveConfig;

class TRTYFastArchiveManager
    : public NRTYServer::IIndexComponentManager
    , public IFastArchive
{
public:

    TRTYFastArchiveManager()
        : NRTYServer::IIndexComponentManager(FASTARCHIVE_COMPONENT_NAME)
    {
    }

    // NRTYServer::IIndexComponentManager
    bool GetDocInfo(const ui32 docId, NJson::TJsonValue& result) const override;
    ui32 GetDocumentsCount() const override;
    void InitInteractions(const NRTYServer::IIndexManagersStorage& /* storage */) override {}
    bool UpdateDoc(ui32 /*docId*/, const TParsedDocument::TPtr /*doc*/) override {
        return false;
    }

    ui32 RemoveDocids(const TVector<ui32>& /*docids*/) override {
        return 0;
    }

    // IFastArchive
    const IFastArchiveDoc* GetDoc(ui32 docId) const override;

    virtual const TBulkFastArchive& GetArchive() const = 0;
};

class TRTYFastArchiveDiskManager
    : public TRTYFastArchiveManager
    , public TBulkFastArchive
{
public:
    TRTYFastArchiveDiskManager(const TString& file);

    // NRTYServer::IIndexComponentManager
    bool DoOpen() override;
    bool DoClose() override;

    // IFastArchive
    bool HasProperty(const TStringBuf& name) const override {
        return Properties.contains(name);
    }

    const TBulkFastArchive& GetArchive() const override {
        return *this;
    }
private:
    const TString ArchiveFile;

    TSet<TString> Properties;
};

class TRTYFastArchiveMemoryManager: public TRTYFastArchiveManager {
public:
    TRTYFastArchiveMemoryManager(const TBulkFastArchive& archive, const TRTYFastArchiveConfig& config)
        : Archive(archive)
        , Config(config)
    {}

    bool DoOpen() override { return true; }
    bool DoClose() override { return true; }

    bool HasProperty(const TStringBuf& name) const override;

    const TBulkFastArchive& GetArchive() const override {
        return Archive;
    }
private:
    const TBulkFastArchive& Archive;
    const TRTYFastArchiveConfig& Config;
};
