#pragma once

#include "archive.h"

#include <saas/rtyserver/indexer_core/document_parser.h>

class TRTYFastArchiveParsedEntity: public TParsedDocument::TParsedEntity {
private:
    TFastArchiveDocWriter Writer;

protected:
    virtual void DoApplyPatch(const TParsedDocument& doc);

public:
    TRTYFastArchiveParsedEntity(TConstructParams& params)
        : TParsedDocument::TParsedEntity(params)
    {}

    const TFastArchiveDocWriter& GetWriter() const {
        return Writer;
    }

    TFastArchiveDocWriter& MutableWriter() {
        return Writer;
    }
};

class TRTYFastArchiveParser: public TComponentParser {
public:
    virtual void Parse(TParsingContext& context) const;
};
