#include "builder.h"
#include <saas/rtyserver/config/const.h>

TRTYFullArchiveBuilder::TRTYFullArchiveBuilder(IFAManager* manager, const TString& componentName)
    : TBaseIndexBuilder(manager->GetRTYConfig(), componentName)
    , Manager(manager)
{}

NRTYServer::IIndexComponentManager* TRTYFullArchiveBuilder::GetManager() {
    return Manager;
}

void TRTYFullArchiveBuilder::Index(int threadID, const TParsedDocument& document, const ui32 docId) {
    TBaseIndexBuilder::Index(threadID, document, docId);
    Manager->Index(document, docId);
}

bool TRTYFullArchiveBuilder::DoClose(const NRTYServer::TBuilderCloseContext& context) {
    Manager->Remap(context.RemapTable);
    return true;
}

bool TRTYFullArchiveBuilder::Start() {
    return true;
}

bool TRTYFullArchiveBuilder::Stop() {
    return true;
}
