#pragma once

#include "manager.h"

#include <saas/rtyserver/indexer_core/indexer_core.h>
#include <saas/rtyserver/components/generator/builder.h>

class TParsedDocument;
class TRTYFullArchiveConfig;

class TRTYFullArchiveBuilder: public TBaseIndexBuilder {
public: // NRTYServer::IIndexComponentBuilder
    TRTYFullArchiveBuilder(IFAManager* manager, const TString& componentName);
    NRTYServer::IIndexComponentManager* GetManager() override;
    void Index(int threadID, const TParsedDocument& document, const ui32 docId) override;
    bool DoClose(const NRTYServer::TBuilderCloseContext& context) override;
    bool Start() override;
    bool Stop() override;
    bool CheckIndexDocIds(const TString& /*indexPath*/) const override {
        return true;
    }

private:
    IFAManager* Manager;
};
