#pragma once

#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/indexer_core/normalizer.h>
#include <saas/rtyserver/components/generator/component.h>
#include <saas/rtyserver/config/globals.h>

class TRTYFullArchiveConfig;

class TRTYFullArchive: public TBaseIndexComponent {
protected:
    const TRTYFullArchiveConfig& ComponentConfig;
    TIndexFiles IndexFiles;
    NRTYServer::TNormalizersCollection Normalizers;

public:
    explicit TRTYFullArchive(const TRTYServerConfig& config);

    THolder<NRTYServer::IIndexComponentBuilder> CreateBuilder(const NRTYServer::TBuilderConstructionContext& context) const override;
    THolder<NRTYServer::IIndexComponentManager> CreateManager(const NRTYServer::TManagerConstructionContext& context) const override;
    NRTYServer::IComponentParser::TPtr BuildParser() const override;
    NRTYServer::IParsedEntity::TPtr BuildParsedEntity(NRTYServer::IParsedEntity::TConstructParams& params) const override;
    TString GetName() const override;

    bool IsCommonSearch() const override {
        return false;
    }

    TPriorityInfo GetPriority() const override {
        TPriorityInfo result = TBaseIndexComponent::GetPriority();
        result.ComponentPriority = FULLARC_COMPONENT_PRIORITY;
        result.BuilderPriority = FULLARC_BUILDER_PRIORITY;
        result.ManagerPriority = FULLARC_MANAGER_PRIORITY;
        return result;
    }

    bool HasIndexFiles(const TString& path) const override;
    bool IsEmptyIndex(const TString& path) const override;
    bool IsFinalIndex(const TString& path) const override;

    THolder<TPruningConfig::ICalcer> CreatePruningCalcer(const NRTYServer::IIndexManagersStorage* /*managers*/) const override {
        return {};
    }

    const TIndexFiles& GetIndexFiles() const override {
        return IndexFiles;
    }

    bool DoMerge(const NRTYServer::TMergeContext& rtyContext) const override;
    bool DoAllRight(const NRTYServer::TNormalizerContext& context) const override;
    void CheckAndFix(const NRTYServer::TNormalizerContext& context) const override;
    bool CheckAlways() const override;
    bool GetInfoChecker(NRTYServer::TInfoChecker& info) const override;
    bool CheckConfig() const override;
    void SearchCustom(const TVector<IIndexController::TPtr>& controllers, ICustomReportBuilder& builder, const TRTYSearchRequestContext& context) const override;

private:
    static NRTYServer::IIndexComponent::TFactory::TRegistrator<TRTYFullArchive> Registrator;
};
