#pragma once

#include <saas/library/daemon_base/module/module.h>
#include <saas/rtyserver/config/config.h>
#include <saas/rtyserver/config/layers.h>

#include <kernel/multipart_archive/config/config.h>

#include <util/generic/set.h>

class TRTYFullArchiveConfig: public TPluginConfig<TRTYServerConfig::IComponentConfig> {
public:
    struct TExtendedMultipartConfig: public NRTYArchive::TMultipartConfig {
        using TBase = NRTYArchive::TMultipartConfig;

        void Init(const TYandexConfig::Section& section);
        void Check() const;
        void ToString(IOutputStream& so) const;
        TString ToString(const char* sectionName) const;

        bool LockFATFile = true;
    };

    using TLayers = TMap<TString, TExtendedMultipartConfig>;

protected:
    virtual bool DoCheck() const;
    virtual void DoInit(const TYandexConfig::Section& componentSection);
    virtual void DoToString(IOutputStream& so) const;

public:
    TRTYFullArchiveConfig();

    const TExtendedMultipartConfig& GetLayer(const TString& name) const;

    bool GetDisablePartsOptimization() const noexcept {
        return DisablePartsOptimization;
    }

    const TLayers& GetLayers() const {
        return Layers;
    }
    const TSet<TString>& GetActiveLayersTemp() const {
        return ActiveLayersTemp;
    }
    const TSet<TString>& GetActiveLayersFinal() const {
        return ActiveLayersFinal;
    }
    const TString& GetMainLayer() const {
        return MainLayer;
    }

private:
    static TRTYServerConfig::IComponentConfig::TFactory::TRegistrator<TRTYFullArchiveConfig> ConfigRegistrator;

private:
    bool DisablePartsOptimization = false;
    bool NoFullLayer = false;
    TLayers Layers;
    TExtendedMultipartConfig DefaultLayerConfig;
    TSet<TString> ActiveLayersTemp;
    TSet<TString> ActiveLayersFinal;
    TSet<TString> LightLayersConfig; // for ToString()
    TString MainLayer = NRTYServer::NFullArchive::BaseLayer;
};
