#include "ddk_manager.h"

#include <saas/rtyserver/config/const.h>

TDDKManager::TDDKManager(const IFAManager& manager)
    : FullArc(manager)
{
}

bool TDDKManager::CheckDeadLine(ui32 /*docId*/, ui32 /*currentTimeMinutes*/) const {
    return false;
}

void TDDKManager::MarkForDelete(ui32 /*docId*/, ui32 /*marker*/) const {
    FAIL_LOG("Not implemented: fullarc-based DDK manager is read-only");
}

void TDDKManager::UpdateVersion(ui32 /*docId*/, ui32 /*version*/) const {
    FAIL_LOG("Not implemented: fullarc-based DDK manager is read-only");
}

void TDDKManager::UpdateTimestamp(ui32 /*docId*/, ui32 /*timestamp*/) const {
    FAIL_LOG("Not implemented: fullarc-based DDK manager is read-only");
}

void TDDKManager::UpdateVersionWithTimestamp(ui32 /*docId*/, ui32 /*version*/, ui32 /*timestamp*/) const {
    FAIL_LOG("Not implemented: fullarc-based DDK manager is read-only");
}

ui32 TDDKManager::GetSourceWithNewVersion(ui32 /*docId*/) const {
    return 0;
}

ui32 TDDKManager::GetVersion(ui32 docId) const {
    return FullArc.GetDoc(docId)->GetVersion();
}

ui32 TDDKManager::GetTimeLiveStart(ui32 docId) const {
    return FullArc.GetDoc(docId)->GetTimestamp();
}

ui32 TDDKManager::GetParsedEntitiesHash(ui32 docId) const {
    return FullArc.GetDoc(docId)->GetEntitiesHash();
}

ui32 TDDKManager::GetDeadlineIfEnabled(ui32 /*docId*/) const {
    return 0;
}

ui32 TDDKManager::GetDeadline(ui32 /*docId*/) const {
    return 0;
}

ui16 TDDKManager::GetStreamId(ui32 docId) const {
    return FullArc.GetDoc(docId)->GetStreamId();
}

TDocSearchInfo::THash TDDKManager::GetIdentifier(ui32 docId) const {
    return FullArc.GetDoc(docId)->GetDocSearchInfo().GetHash();
}

ui64 TDDKManager::GenerateUrlIdHash(const TDocSearchInfo& searchInfo) const {
    return GenerateUrlIdHash(searchInfo.GetHash());
}

bool TDDKManager::IsDeadlineEnabled() const {
    return false;
}

bool TDDKManager::IsReadOnly() const {
    return true;
}

ui64 TDDKManager::GetUrlId(ui32 /*docId*/) const {
    return 0;
}

ui64 TDDKManager::GenerateUrlIdHash(const TDocSearchInfo::THash& hash) const {
    return hash.Head<ui64>();
}

