#pragma once

#include <saas/rtyserver/common/common_rty.h>
#include <saas/rtyserver/indexer_core/abstract_model.h>
#include <saas/rtyserver/components/fullarchive/manager.h>

class TDDKManager
    : public IDDKManager
    , public IUrlIdInfo
{
public:
    explicit TDDKManager(const IFAManager& manager);

public: // IDDKManager
    virtual const IUrlIdInfo* GetUrlIdInfo() const override final {
        return this;
    }

    virtual bool CheckDeadLine(ui32 docId, ui32 currentTimeMinutes) const override final;
    virtual void MarkForDelete(ui32 docId, ui32 marker) const override final;
    virtual void UpdateVersion(ui32 docId, ui32 version) const override final;
    virtual void UpdateTimestamp(ui32 docId, ui32 timestamp) const override final;
    virtual void UpdateVersionWithTimestamp(ui32 docId, ui32 version, ui32 timestamp) const override final;

    virtual ui32 GetSourceWithNewVersion(ui32 docId) const override final;
    virtual ui32 GetVersion(ui32 docId) const override final;
    virtual ui32 GetTimeLiveStart(ui32 docId) const override final;
    virtual ui32 GetParsedEntitiesHash(ui32 docId) const override final;
    virtual ui32 GetDeadlineIfEnabled(ui32 docId) const override final;
    virtual ui32 GetDeadline(ui32 docId) const override final;
    virtual ui16 GetStreamId(ui32 docId) const override final;

    virtual TDocSearchInfo::THash GetIdentifier(ui32 docId) const override final;

    virtual ui64 GenerateUrlIdHash(const TDocSearchInfo& searchInfo) const override final;

    virtual bool IsDeadlineEnabled() const override final;
    virtual bool IsReadOnly() const override final;

public: // IUrlIdInfo
    virtual ui64 GetUrlId(ui32 docId) const override final;

protected:
    virtual ui64 GenerateUrlIdHash(const TDocSearchInfo::THash& hash) const;

protected:
    const IFAManager& FullArc;
};
