#pragma once

#include <saas/rtyserver/indexer_core/normalizer.h>

class TRTYFullArchiveConfig;

class TArchiveFilesNormalizer: public NRTYServer::INormalizer {
public:
    TArchiveFilesNormalizer(const TRTYServerConfig& config, const TRTYFullArchiveConfig& componentConfig);

    virtual const char* Name() const;
    virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;
    virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;

private:
    bool CheckOrFixFiles(const NRTYServer::TNormalizerContext& context, bool fix) const;

private:
    const TRTYFullArchiveConfig& ComponentConfig;
};
